/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.screens.mainMenu;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.GameCursor;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.credits.CreditsScreen;
import com.megacrit.cardcrawl.helpers.FontHelper;
import com.megacrit.cardcrawl.helpers.Hitbox;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.helpers.InputHelper;
import com.megacrit.cardcrawl.helpers.MathHelper;
import com.megacrit.cardcrawl.helpers.TipTracker;
import com.megacrit.cardcrawl.localization.UIStrings;
import com.megacrit.cardcrawl.metrics.Metrics;
import com.megacrit.cardcrawl.scenes.TitleBackground;
import com.megacrit.cardcrawl.screens.CharSelectInfo;
import com.megacrit.cardcrawl.screens.charSelect.CharacterSelectScreen;
import com.megacrit.cardcrawl.screens.leaderboards.LeaderboardScreen;
import com.megacrit.cardcrawl.screens.mainMenu.CardLibraryScreen;
import com.megacrit.cardcrawl.screens.mainMenu.EarlyAccessPopup;
import com.megacrit.cardcrawl.screens.mainMenu.MenuButton;
import com.megacrit.cardcrawl.screens.mainMenu.MenuCancelButton;
import com.megacrit.cardcrawl.screens.mainMenu.MenuSmallButton;
import com.megacrit.cardcrawl.screens.mainMenu.PatchNotesScreen;
import com.megacrit.cardcrawl.screens.mainMenu.RelicViewScreen;
import com.megacrit.cardcrawl.screens.options.OptionsPanel;
import com.megacrit.cardcrawl.screens.saveAndContinue.SaveAndContinue;
import com.megacrit.cardcrawl.screens.stats.StatsScreen;
import com.megacrit.cardcrawl.screens.trial.TrialScreen;
import com.megacrit.cardcrawl.steam.SteamSaveSync;
import com.megacrit.cardcrawl.ui.buttons.ConfirmButton;
import com.megacrit.cardcrawl.ui.panels.RenamePanel;
import com.megacrit.cardcrawl.unlock.UnlockTracker;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MainMenuScreen {
    private static final Logger logger = LogManager.getLogger(MainMenuScreen.class.getName());
    private static final UIStrings uiStrings = CardCrawlGame.languagePack.getUIString("MainMenuScreen");
    public static final String[] TEXT = MainMenuScreen.uiStrings.TEXT;
    private static final String VERSION_INFO = TEXT[0] + CardCrawlGame.VERSION_NUM;
    private Hitbox nameEditHb = new Hitbox(0.0f, (float)Settings.HEIGHT - 80.0f * Settings.scale, 300.0f * Settings.scale, 120.0f * Settings.scale);
    public String newName;
    public boolean darken = false;
    public Color screenColor = new Color(0.0f, 0.0f, 0.0f, 0.0f);
    public static final float OVERLAY_ALPHA = 0.8f;
    private Color overlayColor = new Color(0.0f, 0.0f, 0.0f, 0.0f);
    public boolean fadedOut = false;
    public boolean isFadingOut = false;
    public long windId = 0L;
    private CharSelectInfo charInfo = null;
    public TitleBackground bg = new TitleBackground();
    private EarlyAccessPopup eaPopup = new EarlyAccessPopup();
    public CurScreen screen = CurScreen.MAIN_MENU;
    private RenamePanel renamePanel = new RenamePanel();
    public StatsScreen statsScreen = new StatsScreen();
    public TrialScreen trial = new TrialScreen();
    public CardLibraryScreen cardLibraryScreen = new CardLibraryScreen();
    public LeaderboardScreen leaderboardsScreen = new LeaderboardScreen();
    public RelicViewScreen relicScreen = new RelicViewScreen();
    public CreditsScreen creditsScreen = new CreditsScreen();
    public PatchNotesScreen patchNotesScreen = new PatchNotesScreen();
    public CharacterSelectScreen charSelectScreen = new CharacterSelectScreen();
    public ConfirmButton confirmButton = new ConfirmButton(TEXT[1]);
    public MenuCancelButton cancelButton = new MenuCancelButton();
    private Hitbox patchNotesHb = new Hitbox(0.0f, 0.0f, 200.0f * Settings.scale, 30.0f * Settings.scale);
    private float settingsAngle = 0.0f;
    private Hitbox settingsHb = new Hitbox(64.0f * Settings.scale, 64.0f * Settings.scale);
    public OptionsPanel optionPanel = new OptionsPanel();
    public boolean isSettingsUp = false;
    private Hitbox deckHb = new Hitbox(-1000.0f, 0.0f, 400.0f * Settings.scale, 80.0f * Settings.scale);
    public ArrayList<MenuButton> buttons = new ArrayList();
    public boolean abandonedRun = false;

    public MainMenuScreen() {
        this(true);
    }

    public MainMenuScreen(boolean playBgm) {
        if (Settings.isDemo && Settings.isShowBuild) {
            TipTracker.reset();
        }
        if (playBgm) {
            CardCrawlGame.music.changeBGM("MENU");
            this.windId = Settings.AMBIANCE_ON ? CardCrawlGame.sound.playAndLoop("WIND") : CardCrawlGame.sound.playAndLoop("WIND", 0.0f);
        }
        UnlockTracker.refresh();
        this.cardLibraryScreen.initialize();
        this.charSelectScreen.initialize();
        this.confirmButton.hide();
        this.updateAmbienceVolume();
        SaveAndContinue.checkForSaves();
        if (Settings.UPLOAD_DATA && !CardCrawlGame.playerPref.getBoolean("funMode", false)) {
            Metrics m = new Metrics();
            m.setValues(false, null, Metrics.MetricRequestType.UPLOAD_FAILED_METRICS);
            Thread t = new Thread(m);
            t.run();
        }
        this.setMainMenuButtons();
    }

    private void setMainMenuButtons() {
        this.buttons.clear();
        int index = 0;
        this.buttons.add(new MenuSmallButton(MenuButton.ClickResult.QUIT, index++));
        this.buttons.add(new MenuSmallButton(MenuButton.ClickResult.CREDITS, index++));
        this.buttons.add(new MenuSmallButton(MenuButton.ClickResult.PATCH_NOTES, index++));
        if (Settings.isBeta) {
            this.buttons.add(new MenuButton(MenuButton.ClickResult.LEADERBOARD, index++));
        }
        if (!Settings.isShowBuild) {
            if (this.statsScreen.statScreenUnlocked()) {
                this.buttons.add(new MenuButton(MenuButton.ClickResult.STATS, index++));
            }
            this.buttons.add(new MenuButton(MenuButton.ClickResult.RELICS, index++));
            this.buttons.add(new MenuButton(MenuButton.ClickResult.CARDS, index++));
        }
        if (SaveAndContinue.ironcladSaveExists || SaveAndContinue.silentSaveExists || SaveAndContinue.crowbotSaveExists) {
            this.buttons.add(new MenuButton(MenuButton.ClickResult.ABANDON_RUN, index++));
            this.buttons.add(new MenuButton(MenuButton.ClickResult.RESUME_GAME, index++));
        } else {
            this.buttons.add(new MenuButton(MenuButton.ClickResult.CHAR_SELECT, index++));
        }
    }

    public void update() {
        if (this.isFadingOut) {
            InputHelper.justClickedLeft = false;
            InputHelper.justReleasedClickLeft = false;
            InputHelper.justClickedRight = false;
            InputHelper.justReleasedClickRight = false;
        }
        if (this.abandonedRun) {
            this.abandonedRun = false;
            this.buttons.remove(this.buttons.size() - 1);
            this.buttons.remove(this.buttons.size() - 1);
            this.buttons.add(new MenuButton(MenuButton.ClickResult.CHAR_SELECT, this.buttons.size()));
        }
        if (this.eaPopup != null && EarlyAccessPopup.isUp) {
            this.eaPopup.update();
            InputHelper.justClickedLeft = false;
        } else {
            this.eaPopup = null;
        }
        if (Settings.isInfo && Gdx.input.isKeyJustPressed(62)) {
            SteamSaveSync.deleteAllCloudFiles(SteamSaveSync.getAllCloudFiles());
            logger.info("[STEAM] Deleted all Cloud Files");
        }
        this.cancelButton.update();
        this.updateSettings();
        if (!this.isSettingsUp && this.screen != CurScreen.RENAME) {
            for (MenuButton b : this.buttons) {
                b.update();
            }
        }
        switch (this.screen) {
            case CHAR_SELECT: {
                this.charSelectScreen.update();
                break;
            }
            case CARD_LIBRARY: {
                this.cardLibraryScreen.update();
                break;
            }
            case DAILY: {
                break;
            }
            case BANNER_DECK_VIEW: {
                break;
            }
            case MAIN_MENU: {
                if (!this.patchNotesHb.hovered || !InputHelper.justClickedLeft) break;
                InputHelper.justClickedLeft = false;
                this.patchNotesScreen.open();
                break;
            }
            case LEADERBOARD: {
                this.leaderboardsScreen.update();
                break;
            }
            case RELIC_VIEW: {
                this.relicScreen.update();
                break;
            }
            case RENAME: {
                break;
            }
            case SETTINGS: {
                break;
            }
            case TRIALS: {
                break;
            }
            case STATS: {
                this.statsScreen.update();
                break;
            }
            case CREDITS: {
                this.creditsScreen.update();
                break;
            }
            case PATCH_NOTES: {
                this.patchNotesScreen.update();
                break;
            }
        }
        this.renamePanel.update();
        this.bg.update();
        this.screenColor.a = this.darken ? MathHelper.popLerpSnap(this.screenColor.a, 0.8f) : MathHelper.popLerpSnap(this.screenColor.a, 0.0f);
        if (!this.statsScreen.screenUp && !this.trial.screenUp) {
            this.updateRenameArea();
        }
        if (this.charInfo != null && this.charInfo.resumeGame) {
            this.deckHb.update();
            if (this.deckHb.justHovered) {
                CardCrawlGame.sound.play("UI_HOVER");
            }
        }
        if (!this.isFadingOut) {
            this.handleInput();
        }
        this.fadeOut();
    }

    private void updateSettings() {
        if (this.renamePanel.shown) {
            return;
        }
        this.settingsHb.update();
        if (this.settingsHb.justHovered) {
            CardCrawlGame.sound.play("UI_HOVER");
        }
        if (this.isSettingsUp) {
            if (Gdx.input.isKeyJustPressed(253)) {
                TipTracker.reset();
                logger.info("RESET ALL FTUE TIPS");
            }
            this.settingsAngle += Gdx.graphics.getDeltaTime() * 300.0f;
            if (this.settingsAngle > 360.0f) {
                this.settingsAngle -= 360.0f;
            }
        } else {
            this.settingsAngle = this.settingsHb.hovered ? MathHelper.angleLerpSnap(this.settingsAngle, 359.9f) : MathHelper.angleLerpSnap(this.settingsAngle, 0.0f);
        }
        if (!EarlyAccessPopup.isUp && (this.settingsHb.hovered && InputHelper.justClickedLeft || InputHelper.pressedEscape && this.screen == CurScreen.MAIN_MENU) && !this.isFadingOut) {
            if (!this.isSettingsUp) {
                GameCursor.hidden = false;
                CardCrawlGame.sound.play("END_TURN");
                this.isSettingsUp = true;
                InputHelper.pressedEscape = false;
                this.lighten();
                this.statsScreen.hide();
                this.trial.hide();
                this.cancelButton.hide();
                CardCrawlGame.cancelButton.show(TEXT[2]);
                this.screen = CurScreen.SETTINGS;
            } else if (!EarlyAccessPopup.isUp) {
                this.isSettingsUp = false;
                CardCrawlGame.cancelButton.hide();
                this.screen = CurScreen.MAIN_MENU;
                if (this.screen == CurScreen.MAIN_MENU) {
                    this.cancelButton.hide();
                }
            }
            this.statsScreen.hide();
        }
        if (this.isSettingsUp) {
            this.optionPanel.update();
        }
        CardCrawlGame.cancelButton.update();
    }

    private void updateRenameArea() {
        if (this.screen == CurScreen.MAIN_MENU) {
            this.nameEditHb.update();
        }
        if (this.nameEditHb.hovered && InputHelper.justClickedLeft) {
            InputHelper.justClickedLeft = false;
            this.nameEditHb.hovered = false;
            this.renamePanel.show(CardCrawlGame.playerName);
            this.screen = CurScreen.RENAME;
        }
        if (this.bg.slider <= 0.1f && !CardCrawlGame.ftuePopupShown) {
            CardCrawlGame.ftuePopupShown = true;
            CardCrawlGame.playerPref.putBoolean("ftuePopupShown", true);
            this.renamePanel.show(CardCrawlGame.playerName);
            this.screen = CurScreen.RENAME;
        }
    }

    private void handleInput() {
        this.confirmButton.update();
    }

    public void fadeOutMusic() {
        CardCrawlGame.music.fadeOutBGM();
        if (Settings.AMBIANCE_ON) {
            CardCrawlGame.sound.fadeOut("WIND", this.windId);
        }
    }

    public void render(SpriteBatch sb) {
        this.bg.render(sb);
        this.cancelButton.render(sb);
        this.renderNameEdit(sb);
        for (MenuButton b : this.buttons) {
            b.render(sb);
        }
        this.patchNotesHb.render(sb);
        sb.setColor(this.screenColor);
        sb.draw(ImageMaster.WHITE_SQUARE_IMG, 0.0f, 0.0f, (float)Settings.WIDTH, (float)Settings.HEIGHT);
        if (this.isFadingOut) {
            this.confirmButton.update();
            this.renderSettingsIcon(sb);
        }
        if (this.screen == CurScreen.CHAR_SELECT) {
            this.charSelectScreen.render(sb);
        }
        sb.setColor(this.overlayColor);
        sb.draw(ImageMaster.WHITE_SQUARE_IMG, 0.0f, 0.0f, (float)Settings.WIDTH, (float)Settings.HEIGHT);
        this.renderSettings(sb);
        this.confirmButton.render(sb);
        if (this.patchNotesHb.hovered) {
            FontHelper.renderSmartText(sb, FontHelper.cardDescFont_N, VERSION_INFO, 20.0f * Settings.scale - 700.0f * this.bg.slider, 30.0f * Settings.scale, 10000.0f, 32.0f * Settings.scale, new Color(1.0f, 1.0f, 1.0f, 1.0f));
        } else {
            FontHelper.renderSmartText(sb, FontHelper.cardDescFont_N, VERSION_INFO, 20.0f * Settings.scale - 700.0f * this.bg.slider, 30.0f * Settings.scale, 10000.0f, 32.0f * Settings.scale, new Color(1.0f, 1.0f, 1.0f, 0.3f));
        }
        switch (this.screen) {
            case CARD_LIBRARY: {
                this.cardLibraryScreen.render(sb);
                break;
            }
            case DAILY: {
                break;
            }
            case BANNER_DECK_VIEW: {
                break;
            }
            case MAIN_MENU: {
                break;
            }
            case RELIC_VIEW: {
                this.relicScreen.render(sb);
                break;
            }
            case RENAME: {
                break;
            }
            case SETTINGS: {
                break;
            }
            case TRIALS: {
                break;
            }
            case LEADERBOARD: {
                this.leaderboardsScreen.render(sb);
                break;
            }
            case STATS: {
                this.statsScreen.render(sb);
                break;
            }
            case CREDITS: {
                this.creditsScreen.render(sb);
                this.renderSettingsIcon(sb);
                break;
            }
            case PATCH_NOTES: {
                this.patchNotesScreen.render(sb);
                break;
            }
        }
        this.renamePanel.render(sb);
        if (this.eaPopup != null) {
            this.eaPopup.render(sb);
        }
    }

    private void renderSettingsIcon(SpriteBatch sb) {
        sb.setColor(Color.WHITE);
        sb.draw(ImageMaster.SETTINGS_ICON, (float)(Settings.WIDTH - 32) - 42.0f * Settings.scale + this.bg.slider * 74.0f * Settings.scale, (float)(Settings.HEIGHT - 32) - 42.0f * Settings.scale, 32.0f, 32.0f, 64.0f, 64.0f, Settings.scale, Settings.scale, this.settingsAngle + this.bg.slider * 480.0f, 0, 0, 64, 64, false, false);
        if (this.settingsHb.hovered) {
            sb.setBlendFunction(770, 1);
            sb.setColor(new Color(1.0f, 1.0f, 1.0f, 0.25f));
            sb.draw(ImageMaster.SETTINGS_ICON, (float)(Settings.WIDTH - 32) - 42.0f * Settings.scale + this.bg.slider * 74.0f * Settings.scale, (float)(Settings.HEIGHT - 32) - 42.0f * Settings.scale, 32.0f, 32.0f, 64.0f, 64.0f, Settings.scale, Settings.scale, this.settingsAngle + this.bg.slider * 480.0f, 0, 0, 64, 64, false, false);
            sb.setBlendFunction(770, 771);
        }
    }

    private void renderSettings(SpriteBatch sb) {
        if (!this.isFadingOut) {
            this.renderSettingsIcon(sb);
        }
        if (this.isSettingsUp) {
            this.optionPanel.render(sb);
        }
        CardCrawlGame.cancelButton.render(sb);
        this.settingsHb.move((float)Settings.WIDTH - 42.0f * Settings.scale + this.bg.slider * 74.0f * Settings.scale, (float)Settings.HEIGHT - 42.0f * Settings.scale);
        this.settingsHb.render(sb);
    }

    private void renderNameEdit(SpriteBatch sb) {
        String derp = "";
        derp = CardCrawlGame.playerName;
        if (!this.nameEditHb.hovered) {
            FontHelper.renderSmartText(sb, FontHelper.cardTitleFont_N, derp, 30.0f * Settings.scale - 500.0f * this.bg.slider, (float)Settings.HEIGHT - 24.0f * Settings.scale, 1000.0f, 30.0f * Settings.scale, Color.GOLD);
        } else {
            FontHelper.renderSmartText(sb, FontHelper.cardTitleFont_N, derp, 30.0f * Settings.scale - 500.0f * this.bg.slider, (float)Settings.HEIGHT - 24.0f * Settings.scale, 1000.0f, 30.0f * Settings.scale, Settings.GREEN_TEXT_COLOR);
        }
        FontHelper.renderSmartText(sb, FontHelper.cardDescFont_N, TEXT[3], 30.0f * Settings.scale - 500.0f * this.bg.slider, (float)Settings.HEIGHT - 60.0f * Settings.scale, 1000.0f, 30.0f * Settings.scale, Color.SKY);
        this.nameEditHb.render(sb);
    }

    private void fadeOut() {
        if (this.isFadingOut && !this.fadedOut) {
            this.overlayColor.a += Gdx.graphics.getDeltaTime();
            if (this.overlayColor.a > 1.0f) {
                this.overlayColor.a = 1.0f;
                this.fadedOut = true;
            }
        } else if (this.isSettingsUp) {
            if (this.overlayColor.a != 0.8f) {
                this.overlayColor.a += Gdx.graphics.getDeltaTime() * 2.0f;
                if (this.overlayColor.a > 0.8f) {
                    this.overlayColor.a = 0.8f;
                }
            }
        } else if (this.overlayColor.a != 0.0f) {
            this.overlayColor.a -= Gdx.graphics.getDeltaTime() * 2.0f;
            if (this.overlayColor.a < 0.0f) {
                this.overlayColor.a = 0.0f;
            }
        }
    }

    public void updateAmbienceVolume() {
        if (Settings.AMBIANCE_ON) {
            CardCrawlGame.sound.adjustVolume("WIND", this.windId);
        } else {
            CardCrawlGame.sound.adjustVolume("WIND", this.windId, 0.0f);
        }
    }

    public void darken() {
        this.darken = true;
    }

    public void lighten() {
        this.darken = false;
    }

    public void hideMenuButtons() {
        for (MenuButton b : this.buttons) {
            b.hide();
        }
    }

    public static enum CurScreen {
        CHAR_SELECT,
        RELIC_VIEW,
        BANNER_DECK_VIEW,
        DAILY,
        TRIALS,
        SETTINGS,
        MAIN_MENU,
        RENAME,
        STATS,
        CARD_LIBRARY,
        CREDITS,
        PATCH_NOTES,
        NONE,
        LEADERBOARD;

    }
}

